<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class QuartWorking extends Model 
{

    protected $table = 'quart_workings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('time_start', 'time_close', 'service_station_id');
    protected $visible = array('time_start', 'time_close', 'service_station_id');

    public function service_station()
    {
        return $this->belongsTo('ServiceStation', 'service_station_id');
    }

}